/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StoredItemStack;
import com.tom.storagemod.block.StorageTerminalBase;
import com.tom.storagemod.gui.ContainerStorageTerminal;
import com.tom.storagemod.item.WirelessTerminal;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityStorageTerminal
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    private IItemHandler itemHandler;
    private Map<StoredItemStack, Long> items = new HashMap<StoredItemStack, Long>();
    private int sort;
    private String lastSearch = "";
    private boolean updateItems;

    public TileEntityStorageTerminal() {
        super(StorageMod.terminalTile);
    }

    public TileEntityStorageTerminal(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public Container createMenu(int id, PlayerInventory plInv, PlayerEntity arg2) {
        return new ContainerStorageTerminal(id, plInv, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("ts.storage_terminal");
    }

    public Map<StoredItemStack, Long> getStacks() {
        this.updateItems = true;
        return this.items;
    }

    public StoredItemStack pullStack(StoredItemStack stack, long max) {
        if (stack != null && this.itemHandler != null && max > 0L) {
            ItemStack st = stack.getStack();
            StoredItemStack ret = null;
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack pulled;
                ItemStack s = this.itemHandler.getStackInSlot(i);
                if (!ItemStack.func_179545_c((ItemStack)s, (ItemStack)st) || !ItemStack.func_77970_a((ItemStack)s, (ItemStack)st) || (pulled = this.itemHandler.extractItem(i, (int)max, false)).func_190926_b()) continue;
                if (ret == null) {
                    ret = new StoredItemStack(pulled);
                } else {
                    ret.grow(pulled.func_190916_E());
                }
                if ((max -= (long)pulled.func_190916_E()) < 1L) break;
            }
            return ret;
        }
        return null;
    }

    public StoredItemStack pushStack(StoredItemStack stack) {
        if (stack != null && this.itemHandler != null) {
            ItemStack is = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)stack.getActualStack(), (boolean)false);
            if (is.func_190926_b()) {
                return null;
            }
            return new StoredItemStack(is);
        }
        return stack;
    }

    public ItemStack pushStack(ItemStack itemstack) {
        StoredItemStack is = this.pushStack(new StoredItemStack(itemstack));
        return is == null ? ItemStack.field_190927_a : is.getActualStack();
    }

    public void pushOrDrop(ItemStack st) {
        if (st.func_190926_b()) {
            return;
        }
        StoredItemStack st0 = this.pushStack(new StoredItemStack(st));
        if (st0 != null) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (ItemStack)st0.getActualStack());
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.updateItems) {
            BlockState st = this.field_145850_b.func_180495_p(this.field_174879_c);
            Direction d = (Direction)st.func_177229_b((Property)StorageTerminalBase.FACING);
            StorageTerminalBase.TerminalPos p = (StorageTerminalBase.TerminalPos)((Object)st.func_177229_b(StorageTerminalBase.TERMINAL_POS));
            if (p == StorageTerminalBase.TerminalPos.UP) {
                d = Direction.UP;
            }
            if (p == StorageTerminalBase.TerminalPos.DOWN) {
                d = Direction.DOWN;
            }
            TileEntity invTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(d));
            this.items.clear();
            if (invTile != null) {
                LazyOptional lih = invTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d.func_176734_d());
                this.itemHandler = (IItemHandler)lih.orElse(null);
                if (this.itemHandler != null) {
                    IntStream.range(0, this.itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)this.itemHandler).getStackInSlot(arg_0)).filter(s -> !s.func_190926_b()).map(StoredItemStack::new).forEach(s -> this.items.merge((StoredItemStack)s, s.getQuantity(), (a, b) -> a + b));
                }
            }
            this.updateItems = false;
        }
    }

    public boolean canInteractWith(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        int d = 4;
        if (player.func_184614_ca().func_77973_b() instanceof WirelessTerminal) {
            d = Math.max(d, ((WirelessTerminal)player.func_184614_ca().func_77973_b()).getRange(player, player.func_184614_ca()));
        }
        if (player.func_184592_cb().func_77973_b() instanceof WirelessTerminal) {
            d = Math.max(d, ((WirelessTerminal)player.func_184592_cb().func_77973_b()).getRange(player, player.func_184592_cb()));
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > (double)(d * 2 * d * 2));
    }

    public int getSorting() {
        return this.sort;
    }

    public void setSorting(int newC) {
        this.sort = newC;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("sort", this.sort);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState st, CompoundNBT compound) {
        this.sort = compound.func_74762_e("sort");
        super.func_230337_a_(st, compound);
    }

    public String getLastSearch() {
        return this.lastSearch;
    }

    public void setLastSearch(String string) {
        this.lastSearch = string;
    }
}

